do
	
	local function GetTotalCount(itemId)
		local realm = GetRealmName();
		
		local totalCount = 0;
		
		local guilds = {};
		
		-- Process all accounts
		for accountName in pairs(DataStore:GetAccounts()) do
		
			-- Process all charracters
			for characterName, character in pairs(DataStore:GetCharacters(realm, accountName)) do
				-- Get only useful info (currency / gear shouldn't contain the stuff we are interested in)
				local bag, bank = DataStore:GetContainerItemCount(character, itemId);
				local auctionHouse = DataStore:GetAuctionHouseItemCount(character, itemId);
				local mail = DataStore:GetMailItemCount(character, itemId);
				
				totalCount = totalCount + bag + bank + auctionHouse + mail;
			end
			
			-- Process all guilds
			for guildName, guild in pairs(DataStore:GetGuilds(realm, accountName)) do
				if not guilds[guildName] then
					-- We don't want itemcounts from a single guild to be counted twice, so first to present data wins
					
					guilds[guildName] = true;
					
					local guild = DataStore:GetGuildBankItemCount(guild, itemId);
				
					totalCount = totalCount + guild;
				end
			end
		end
		
		return totalCount or -1;
	end
	
	local function GetCharacterCount(itemId)
		local character = DataStore:GetCharacter();
		
		local bag, bank = DataStore:GetContainerItemCount(character, itemId);
		local auctionHouse = DataStore:GetAuctionHouseItemCount(character, itemId);
		local mail = DataStore:GetMailItemCount(character, itemId);
		
		return bag, bank, auctionHouse, mail;
	end
	
	local function IsEnabled()
		return (DataStore and DataStore.GetContainerItemCount and DataStore.GetAuctionHouseItemCount and DataStore.GetMailItemCount);
	end
	
	IMRegisterItemCountAddon("DataStore (with guilds)", GetTotalCount, GetCharacterCount, IsEnabled);
	
end
